state GraveWardenSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity, effect_entity2		: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var energy_area   									: GraveWardenVeil;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect, CustomEffect1						: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var fireball										: W3FireGnosisFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var dummy_proj                                      : W3EnergyDummy;
	var custom_anim										: name;
	var cast_hand										: CEntity;
	var vector_attach 									: Vector;
	var randRoll										: float;


	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("qu_nml_108.bnk") )
		{
			theSound.SoundLoadBank( "qu_nml_108.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_keira.bnk") )
		{
			theSound.SoundLoadBank( "magic_keira.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("qu_item_demonic_saddle.bnk") )
		{
			theSound.SoundLoadBank( "qu_item_demonic_saddle.bnk", false );
		}
	
	
	
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_grave();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_grave()
	{
		var monsterCategory 	: EMonsterCategory;
		var tmpName 			: name;
		var tmpBool 			: bool;
		
		switch( parent.spell_name )
		{
			case 'torn_veil':
				{
					theGame.GetEntitiesByTag('torn_veil_spells',ents_destroy);
					for( i=0; i<ents_destroy.Size(); i+=1 )
					{
						ents_destroy[i].AddTimer('destroy_energy_area',0.0f);
					} 	
						
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = thePlayer.GetWorldRotation();
					
					duration = 10;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					parent.templatename = "dlc\magicspellsrev\data\entities\grave_warden_veil.w2ent";
						
					energy_area = (GraveWardenVeil)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), rotation );
					energy_area.AddTimer('destroy_energy_area', duration );
					energy_area.AddTag('torn_veil_spells');
					energy_area.AddTag( 'spells_from_sign' );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'grave_flame':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\grave_warden.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('grave_warden_cone');
					main_effect.DestroyAfter(10);
					
					actors = thePlayer.GetNPCsAndPlayersInCone(5, VecHeading(thePlayer.GetHeadingVector()), 80, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					
					for( i = 0; i < actors.Size(); i += 1 )
					{
						target = (CActor)actors[i];
						
						damage_value = get_damage_value_for_cone( target, GetMagicVigil().get_magic_spellpower() );
						
						theGame.GetMonsterParamsForActor( target, monsterCategory, tmpName, tmpBool, tmpBool, tmpBool);
						if ( monsterCategory == MC_Specter || monsterCategory == MC_Vampire || monsterCategory == MC_Cursed  )
						{
							damage_value *= 1.15;
						}
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitEffect('igni_cone_hit', false, false);
						damage_action.SetHitEffect('igni_cone_hit', true, false);
						damage_action.SetHitReactionType(EHRT_Igni, false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value * 0.35 );
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage_value * 0.35 );
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * damage_value * 0.35 );
						
						if ( RandF() <= 0.33 )
						{
							damage_action.AddEffectInfo( EET_SpellsSlowDownAverage, MaxF( 3, MinF( 8, GetMagicVigil().get_magic_spellpower() *3 ) ) );
						}
						if ( RandF() <= 0.20 )
						{
							damage_action.AddEffectInfo( EET_Burning, 1.5);
						}
						if ( RandF() <= 0.20 )
						{
							damage_action.AddEffectInfo( EET_Poison, 3);
						}
						
						effect_entity = target.CreateFXEntityAtPelvis( 'grave_warden', true );
						effect_entity.PlayEffect( 'flame_short' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'abyss_watcher':
				{
					CustomEffect.effectType = EET_Abysswatcher;
					CustomEffect.creator = GetWitcherPlayer();
					CustomEffect.duration = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'shield_duration', true, true) );
					GetWitcherPlayer().AddEffectCustom( CustomEffect );
					
					CustomEffect1.effectType = EET_WeakeningAura;
					CustomEffect1.creator = GetWitcherPlayer();
					CustomEffect1.duration = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'shield_duration', true, true) );
					GetWitcherPlayer().AddEffectCustom( CustomEffect1 );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			default:		
				break;
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}